#include "Control.h"
#include "Textbook.h"
#include "Network.h"
#include <stdio.h>



int main(int argc, char **argv){
	CControl control;
	printf("Done.  Press enter to exit.");
	getchar();
	return 1;
}



CControl::CControl(){
	mpNetwork = new CNetwork(this);
	mpTrainSet = new CTextbook(100);
	mpTestSet = new CTextbook(1000);

	Train(100);
}



CControl::~CControl(){
	delete mpNetwork;
	delete mpTrainSet;
	delete mpTestSet;
}



void CControl::Train(int nCycles){
	for(mCycle = 0;  mCycle < nCycles;  ++mCycle){
		int pattern;
		for(pattern = 0;  pattern < mpTrainSet->mnPatterns;  ++pattern){
			CPattern *pPattern = mpTrainSet->mdpPatterns[pattern];
			mpNetwork->ForwardPropagate(pPattern->mpInputs);
			mpNetwork->JudgeOutputs(pPattern->mpOutputs);
			mpNetwork->BackwardPropagate();
		}
		float trainingRatioCorrect = mpNetwork->GetAndResetCorrect();

		for(pattern = 0;  pattern < mpTestSet->mnPatterns;  ++pattern){
			CPattern *pPattern = mpTestSet->mdpPatterns[pattern];
			mpNetwork->ForwardPropagate(pPattern->mpInputs);
			mpNetwork->JudgeOutputs(pPattern->mpOutputs);
		}
		float testingRatioCorrect = mpNetwork->GetAndResetCorrect();

		printf("cycle %3d: %.4ftrain  %.4ftest\n", mCycle, trainingRatioCorrect, testingRatioCorrect);
	}
}
