#pragma once
struct CControl;



struct CNeuron{
	float mOutput, mError;
};



struct CLink{
	float mWeight;
};


struct CNetwork{
	CNetwork(CControl *pControl);
	~CNetwork();

	void ForwardPropagate(float *pInputs);
	void JudgeOutputs(float *pCorrectOutputs);
	void BackwardPropagate();

	// SETTINGS AND DATA
	CControl *mpControl;
	float mLearningRate;
	int mnLayers, *mpLayerSizes;
	CNeuron **mdpNeurons;  // mdp = member double-pointer
	CLink ***mtpLinks;  // mtp = member triple-pointer

	// UTILITY FUNCTIONS
	float RangedRandom(float low, float high);

	// STATISTICS
	int mnCorrect, mnWrong;
	void PrintStatistics();
	float GetAndResetCorrect();
};
