#include "Textbook.h"
#include <stdlib.h>



CPattern::CPattern(int nInputs, int nOutputs){
	mpInputs = (float*)malloc(nInputs * sizeof(float));
	mpOutputs = (float*)malloc(nOutputs * sizeof(float));
}



CPattern::~CPattern(){
	free(mpInputs);
	free(mpOutputs);
}



CTextbook::CTextbook(int nPatterns){
	mnPatterns = nPatterns;
	mRange = 32;

	CreatePatterns();
}



CTextbook::~CTextbook(){
	for(int pattern = 0;  pattern < mnPatterns;  ++pattern)
		delete mdpPatterns[pattern];
	free(mdpPatterns);
}



void CTextbook::CreatePatterns(){
	int pattern;
	mdpPatterns = (CPattern**)malloc(mnPatterns * sizeof(CPattern*));
	for(pattern = 0;  pattern < mnPatterns;  ++pattern)
		mdpPatterns[pattern] = new CPattern(mRange*2, 1);

	for(pattern = 0;  pattern < mnPatterns;  ++pattern){
		int x = rand()%mRange;
		int y = rand()%mRange;
		bool bOutput = x+y >= mRange;
		for(int input = 0;  input < mRange;  ++input){
			mdpPatterns[pattern]->mpInputs[input] = (input == x)? 1.0f: 0.0f;
			mdpPatterns[pattern]->mpInputs[input+mRange] = (input == y)? 1.0f: 0.0f;
		}
		mdpPatterns[pattern]->mpOutputs[0] = bOutput? 1.0f: 0.0f;
	}
}
