#include "Control.h"
#include "Textbook.h"
#include "Network.h"
#include <stdio.h>



int main(int argc, char **argv){
	CControl control;
	printf("Done.  Press enter to exit.");
	getchar();
	return 1;
}



CControl::CControl(){
	mpNetwork = new CNetwork(this);
	/* There are 1024 possible patterns in the default setup.  Here we show network 100 of those patterns in mpTrainSet
	and expect it to do fairly well on the remaining patterns.  It's instructive to change the number of train set
	patterns to see how the network performs differently. */
	mpTrainSet = new CTextbook(100);
	mpTestSet = new CTextbook(1000);

	Train(100);
}



CControl::~CControl(){
	delete mpNetwork;
	delete mpTrainSet;
	delete mpTestSet;
}



void CControl::Train(int nCycles){
	for(mCycle = 0;  mCycle < nCycles;  ++mCycle){  // During each cycle of training...
		int pattern;
		for(pattern = 0;  pattern < mpTrainSet->mnPatterns;  ++pattern){  // traing on all the patterns in the train set.
			CPattern *pPattern = mpTrainSet->mdpPatterns[pattern];  // Make a shortcut to the current pattern...
			mpNetwork->ForwardPropagate(pPattern->mpInputs);  // forward propagate the network using the pattern's inputs as the network's inputs...
			mpNetwork->JudgeOutputs(pPattern->mpOutputs);  // find the error by comparing the network's outputs to the desired outputs...
			mpNetwork->BackwardPropagate();  // then, backward propagate the network to adjust to the error found.
		}
		float trainingRatioCorrect = mpNetwork->GetAndResetCorrect();  // Record our "accuracy" during training.

		/* In practice, it's good to test your network's accuracy every cycle of training so that you can compare the
		training accuracy with the testing accuracy throughout the learning process.  This gives a much clearer picture
		of how well the network is responding.  The more standard way of treating a network is to train it until the
		change of the error in the network (improvement) is small. */
		for(pattern = 0;  pattern < mpTestSet->mnPatterns;  ++pattern){
			CPattern *pPattern = mpTestSet->mdpPatterns[pattern];
			mpNetwork->ForwardPropagate(pPattern->mpInputs);
			mpNetwork->JudgeOutputs(pPattern->mpOutputs);
			// Note that we don't call BackwardPropagate here since we are only testing: we don't want to adjust the network to our test data.
		}
		float testingRatioCorrect = mpNetwork->GetAndResetCorrect();  // Record our accuracy during testing.

		printf("cycle %3d: %.4ftrain  %.4ftest\n", mCycle, trainingRatioCorrect, testingRatioCorrect);
	}
}
