#pragma once
struct CTextbook;
struct CNetwork;


/* The control becomes a massive module of the program when the network becomes more sophisticated.
When there's just one network in the system, the control usually runs the network by telling it
to propagate and backpropagate and so on.  But once there is more than one network in the system,
it is usually better to create a mind class which knows how to run the networks and combine their
results.  Then, the control's task is simply to present each pattern to the mind for processing. */
struct CControl{
	CControl();
	~CControl();

	void Train(int nCycles);

	CTextbook *mpTrainSet, *mpTestSet;
	CNetwork *mpNetwork;
	int mCycle;
};
