#pragma once
struct CControl;


/* SIMPLE STRUCTURES
CLink only contains a single float.  It is kept as a separate structure since more sophisticated neural networks require
more data to be associated with each link, for example, momentum.
*/
struct CNeuron{
	float mOutput, mError;
};

struct CLink{
	float mWeight;
};



struct CNetwork{
	/* PRIMARY LIFECYCLE FUNCTIONS
	JudgeOutputs only sets the error in each output node and records statistics on this.  It is kept separate from
	BackwardPropagate so that during testing we can gather statistics without actually changing the network.
	*/
	CNetwork(CControl *pControl);
	void ForwardPropagate(float *pInputs);
	void JudgeOutputs(float *pCorrectOutputs);
	void BackwardPropagate();
	~CNetwork();

	/* SETTINGS AND DATA
	Visualize mdpNeurons as a tree where the top node is the mdpNeurons pointer itself.  It points to several child nodes
	that represent each layer.  In turn, each layer node points to a set of neurons.  mtpLinks similarly points to layer
	nodes.  They then point to neuron nodes.  Each neuron node then points to each link between it and the neurons in the
	previous layer.  Since the neurons in the first layer don't have any links going back, we don't actually have a node
	for the first layer in mtpLinks.
	*/
	CControl *mpControl;
	float mLearningRate;
	int mnLayers, *mpLayerSizes;
	CNeuron **mdpNeurons;  // mdp = member double-pointer
	CLink ***mtpLinks;  // mtp = member triple-pointer

	// UTILITY FUNCTIONS
	float RangedRandom(float low, float high);

	/* STATISTICS
	Each time the network's JudgeOutputs function is called it adds to its statistics record.  Then, when PrintStatistics
	or GetAndResetCorrect is called we not only analyze the record (here the record is just the two ints mnCorrect and
	mnWrong) but we also reset it so that we're keeping a fresh record.  This allows us to print out separate statistics
	for training and testing each cycle.
	*/
	int mnCorrect, mnWrong;
	void PrintStatistics();
	float GetAndResetCorrect();
};
