#include "Textbook.h"
#include <stdlib.h>



CPattern::CPattern(int nInputs, int nOutputs){
	mpInputs = (float*)malloc(nInputs * sizeof(float));
	mpOutputs = (float*)malloc(nOutputs * sizeof(float));
}



CPattern::~CPattern(){
	free(mpInputs);
	free(mpOutputs);
}



CTextbook::CTextbook(int nPatterns){
	mnPatterns = nPatterns;
	mRange = 32;

	CreatePatterns();
}



CTextbook::~CTextbook(){
	for(int pattern = 0;  pattern < mnPatterns;  ++pattern)
		delete mdpPatterns[pattern];
	free(mdpPatterns);
}



/* Normally, patterns are stored in files separate from the program but to simplify things here we mathematically
produce patterns for the network to learn.  As input, we get two random numbers that are between 0 and 31 (or whatever
mRange is set to minus one).  We then add the two numbers and if the sum is smaller than 32, the output is 0, otherwise
it's 1.  To encode each random number we dedicate 32 inputs of the network to each number.  So if the number is 15, we
set the 16th input to 1.0 and the rest to 0.0 (remember that the first input represents 0).  When possible, this is the
best way to present data to a network.

The data produced here has some key qualities which make it amenable to neural-network learning.  The data is balanced
between positive (output is 1.0) and negative (output is 0.0) patterns.  The number of input possibilities is large,
1024 patterns, which makes it harder for the network to simply memorize the answers.  Finally, there is no trivial way
to learn the answer, which would effectively make the number of possible patterns much less.  For example, a bad
problem to solve would be to create a single random number and encode it in binary in the inputs to the network.  Then
ask the network whether it is odd or even.  Since you can tell if a number is odd or even simply by looking at whether
its rightmost input is 0 or 1 there are really only two patterns the network has to see, so it just memorizes them.
*/
void CTextbook::CreatePatterns(){
	int pattern;
	mdpPatterns = (CPattern**)malloc(mnPatterns * sizeof(CPattern*));
	for(pattern = 0;  pattern < mnPatterns;  ++pattern)
		mdpPatterns[pattern] = new CPattern(mRange*2, 1);

	for(pattern = 0;  pattern < mnPatterns;  ++pattern){
		int x = rand()%mRange;
		int y = rand()%mRange;
		bool bOutput = x+y >= mRange;
		for(int input = 0;  input < mRange;  ++input){
			mdpPatterns[pattern]->mpInputs[input] = (input == x)? 1.0f: 0.0f;
			mdpPatterns[pattern]->mpInputs[input+mRange] = (input == y)? 1.0f: 0.0f;
		}
		mdpPatterns[pattern]->mpOutputs[0] = bOutput? 1.0f: 0.0f;
	}
}
