#pragma once


/* A CPattern encodes a single pattern that'll be input into the neural network.  The array of inputs
and outputs is dynamically allocated (malloc) since we generally won't know ahead of time the size of
each pattern. */
struct CPattern{
	CPattern(int nInputs, int nOutputs);
	~CPattern();
	float *mpInputs;
	float *mpOutputs;
};


/* As a neural network project grows, the textbook class becomes a major component.  Here it merely holds
an array of "fake" mathematically-generated patterns for the network to learn from.  In a real use of a
neural network the textbook handles loading and saving patterns to files, and the preprocessing of the
data before it is fed into a network.
*/
struct CTextbook{
	CTextbook(int nPatterns);
	~CTextbook();

	void CreatePatterns();

	int mnPatterns, mRange;
	CPattern **mdpPatterns;
};
